/*!
 * i18n JavaScript Library v0.1.0
 * Copyright (c)2013 Rei
 * Released under the MIT license
 * Such as jQuery.i18n
 * Date: 2013-12-17 13:48
 */

/* support document.getElementsByClassName */
if (!document.getElementsByClassName) {
    document.getElementsByClassName = function (className, element) {
        var children = (element || document).getElementsByTagName('*');
        var elements = new Array();
        for (var i = 0; i < children.length; i++) {
            var child = children[i];
            var classNames = child.className.split(' ');
            for (var j = 0; j < classNames.length; j++) {
                if (classNames[j] == className) {
                    elements.push(child);
                    break;
                }
            }
        }
        return elements;
    };
}

/* jquery1.6.2 ready */
var ready = (function () {

    var readyList,
        DOMContentLoaded,
        class2type = {};
    class2type["[object Boolean]"] = "boolean";
    class2type["[object Number]"] = "number";
    class2type["[object String]"] = "string";
    class2type["[object Function]"] = "function";
    class2type["[object Array]"] = "array";
    class2type["[object Date]"] = "date";
    class2type["[object RegExp]"] = "regexp";
    class2type["[object Object]"] = "object";

    var ReadyObj = {
        isReady:false,
        readyWait:1,
        holdReady:function (hold) {
            if (hold) {
                ReadyObj.readyWait++;
            } else {
                ReadyObj.ready(true);
            }
        },
        ready:function (wait) {
            if ((wait === true && !--ReadyObj.readyWait) || (wait !== true && !ReadyObj.isReady)) {
                if (!document.body) {
                    return setTimeout(ReadyObj.ready, 1);
                }
                ReadyObj.isReady = true;
                if (wait !== true && --ReadyObj.readyWait > 0) {
                    return;
                }
                readyList.resolveWith(document, [ ReadyObj ]);
            }
        },
        bindReady:function () {
            if (readyList) {
                return;
            }
            readyList = ReadyObj._Deferred();
            if (document.readyState === "complete") {
                return setTimeout(ReadyObj.ready, 1);
            }
            if (document.addEventListener) {
                document.addEventListener("DOMContentLoaded", DOMContentLoaded, false);
                window.addEventListener("load", ReadyObj.ready, false);

            } else if (document.attachEvent) {
                document.attachEvent("onreadystatechange", DOMContentLoaded);
                window.attachEvent("onload", ReadyObj.ready);
                var toplevel = false;
                try {
                    toplevel = window.frameElement == null;
                } catch (e) {
                }
                if (document.documentElement.doScroll && toplevel) {
                    doScrollCheck();
                }
            }
        },
        _Deferred:function () {
            var callbacks = [],
                fired,
                firing,
                cancelled,
                deferred = {
                    done:function () {
                        if (!cancelled) {
                            var args = arguments,
                                i,
                                length,
                                elem,
                                type,
                                _fired;
                            if (fired) {
                                _fired = fired;
                                fired = 0;
                            }
                            for (i = 0, length = args.length; i < length; i++) {
                                elem = args[ i ];
                                type = ReadyObj.type(elem);
                                if (type === "array") {
                                    deferred.done.apply(deferred, elem);
                                } else if (type === "function") {
                                    callbacks.push(elem);
                                }
                            }
                            if (_fired) {
                                deferred.resolveWith(_fired[ 0 ], _fired[ 1 ]);
                            }
                        }
                        return this;
                    },

                    resolveWith:function (context, args) {
                        if (!cancelled && !fired && !firing) {
                            args = args || [];
                            firing = 1;
                            try {
                                while (callbacks[ 0 ]) {
                                    callbacks.shift().apply(context, args);//shifts a callback, and applies it to document
                                }
                            }
                            finally {
                                fired = [ context, args ];
                                firing = 0;
                            }
                        }
                        return this;
                    },
                    resolve:function () {
                        deferred.resolveWith(this, arguments);
                        return this;
                    },
                    isResolved:function () {
                        return !!( firing || fired );
                    },
                    cancel:function () {
                        cancelled = 1;
                        callbacks = [];
                        return this;
                    }
                };

            return deferred;
        },
        type:function (obj) {
            return obj == null ?
                String(obj) :
                class2type[ Object.prototype.toString.call(obj) ] || "object";
        }
    }
    function doScrollCheck() {
        if (ReadyObj.isReady) {
            return;
        }

        try {
            document.documentElement.doScroll("left");
        } catch (e) {
            setTimeout(doScrollCheck, 1);
            return;
        }
        ReadyObj.ready();
    }
    if (document.addEventListener) {
        DOMContentLoaded = function () {
            document.removeEventListener("DOMContentLoaded", DOMContentLoaded, false);
            ReadyObj.ready();
        };
    } else if (document.attachEvent) {
        DOMContentLoaded = function () {
            if (document.readyState === "complete") {
                document.detachEvent("onreadystatechange", DOMContentLoaded);
                ReadyObj.ready();
            }
        };
    }
    function ready(fn) {
        ReadyObj.bindReady();
        var type = ReadyObj.type(fn);
        readyList.done(fn);//readyList is result of _Deferred()
    }
    return ready;
})();

var transEnd = null;
ready(function () {
        document.body.style.display = "none";
        if (window.top.opener) {
            window.top.opener.parent.I18N.t(document, transEnd);
        } else {
            window.top.parent.I18N.t(document, transEnd);
        }
        document.body.style.display = "";
    }
);

AJAX = {
    // Create a xmlHttpRequest object - this is the constructor.
    getHTTPObject:function () {
        var http = false;
        if (typeof ActiveXObject != 'undefined') {
            try {
                http = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                try {
                    http = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (E) {
                    http = false;
                }
            }
        } else if (window.XMLHttpRequest) {
            try {
                http = new XMLHttpRequest();
            } catch (e) {
                http = false;
            }
        }
        return http;
    },
    // This function is called from the user's script.
    // Arguments -
    //       url - The url of the serverside script that is to be called.
    //       format - The return type for this function. Could be 'xml', 'json'.
    //       callback - Function that must be called once the data is ready.
    load:function (url, format, callback) {
        var http = this.init();
        if (!http || !url) {
            return;
        }
        if (http.overrideMimeType) {
            http.overrideMimeType('text/xml');
        }
        if (!format) {
            var format = "text"; // Default return type is 'text'
        }
        format = format.toLowerCase();
        // Kill the Cache problem in IE.
        var now = "uid=" + new Date().getTime();
        url += (url.indexOf("?") + 1) ? "&" : "?";
        url += now;
        http.open("GET", url, true);
        http.onreadystatechange = function () {
            if (http.readyState == 4) {
                if (http.status == 200) {
                    var result = "";
                    if (http.responseText) {
                        result = http.responseText;
                    }
                    if (format.charAt(0) == "j") {
                        // \n's in JSON string
                        result = result.replace(/[\n\r]/g, "");
                        result = eval('(' + result + ')');
                    }
                    // Give the data to the callback function.
                    if (callback) {
                        callback(result);
                    }
                }
            }
        }
        http.send(null);
    },
    init:function () {
        return this.getHTTPObject();
    }
}

I18N = {
    defaultLang: i18n.conf.defaultLanguage,
    path:"",
    file:"",
    cookievalid:86400000, //1 day (1000*60*60*24)
    text:{},
    extractLang:function (kvl) {
        var lang;
        for (var i in kvl) {
            var kv = kvl[i].split('=');
            if (kv[0] === 'lang')
                lang = kv[1];
        }
        return lang;
    },
    isFunction:function (obj) {
        return typeof obj === "function";
    },
    isArray:Array.isArray || function (obj) {
        return typeof obj === "array";
    },
    isPlainObject:function (obj) {
        if (!obj || obj.toString() !== "[object Object]" || obj.nodeType || obj.setInterval) {
            return false;
        }
        if (obj.constructor && !obj.hasOwnProperty("constructor") && !obj.constructor.prototype.hasOwnProperty("isPrototypeOf")) {
            return false;
        }
        var key;
        for (key in obj) {
        }
        return key === undefined || obj.hasOwnProperty(key);
    },
    extend:function () {
        var src, copyIsArray, copy, name, options, clone,
            target = arguments[0] || {},
            i = 1,
            length = arguments.length,
            deep = false;
        // deep copy
        if (typeof target === "boolean") {
            deep = target;
            target = arguments[1] || {};
            // skip the boolean and the target
            i = 2;
        }
        if (typeof target !== "object" && !this.isFunction(target)) {
            target = {};
        }
        if (length === i) {
            target = this;
            --i;
        }
        for (; i < length; i++) {
            if ((options = arguments[ i ]) != null) {
                for (name in options) {
                    src = target[ name ];
                    copy = options[ name ];
                    if (target === copy) {
                        continue;
                    }
                    if (deep && copy && ( this.isPlainObject(copy) || (copyIsArray = this.isArray(copy)) )) {
                        if (copyIsArray) {
                            copyIsArray = false;
                            clone = src && this.isArray(src) ? src : [];
                        } else {
                            clone = src && this.isPlainObject(src) ? src : {};
                        }
                        target[ name ] = this.extend(deep, clone, copy);
                    } else if (copy !== undefined) {
                        target[ name ] = copy;
                    }
                }
            }
        }
        return target;
    },
    hasClass:function (ele, cls) {
        return ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
    },
    removeClass:function (ele, cls) {
        if (this.hasClass(ele, cls)) {
            var reg = new RegExp('(\\s|^)' + cls + '(\\s|$)');
            ele.className = ele.className.replace(reg, ' ');
            ele.removeAttribute(cls);
        }
    },
    getElementByAttr:function (e, attr) {
        var tab = [];
        if (e.getAttribute && e.getAttribute(attr) != '' && e.getAttribute(attr) != null) {
            tab.push(e);
        }
        var n = e.firstChild;
        if (n == null || typeof n == 'undefined') return tab;
        do
        {
            var tab2 = this.getElementByAttr(n, attr);
            tab = tab.concat(tab2);
        }
        while ((n = n.nextSibling) != null)
        return tab;
    },
    getCookieLang:function () {
        return this.extractLang(window.top.document.cookie.split('; '));
    },
    getLang:function () {
        if (typeof this.lang !== 'string') {
            if (typeof (this.lang = this.getCookieLang()) === 'string');
            //else if (typeof (this.lang = navigator.language) === 'string');
            //else if (typeof (this.lang = navigator.userLanguage) === 'string');
            else this.lang = this.defaultLang;
        }
        return this.lang.toLowerCase();
    },
    setLang:function (lang, cook) {
        this.lang = lang;
        if (cook) {
            var wl = window.location,
                now = new Date(),
                time = now.getTime();
            time += this.cookievalid;
            now.setTime(time);
            document.cookie = 'lang=' + lang + ';path=/' + ';domain=' + wl.host + ';expires=' + now.toGMTString();
        }
        return this;
    },
    load:function (doc, cb) {
        var self = this, lang = this.getLang();
/*--#FAKE--*/
        self.put(lang, {}).t(doc, cb);
/*--#ENDFAKE--*/
/*--#REAL
        AJAX.load(this.path + 'resources/' + lang + "/" + (this.file == "" ? lang : this.file), "json", function (data) {
            self.put(lang, data).t(doc, cb);
        });
*//*#ENDREAL*/
        return this;
    },
    put:function (lang, data) {
        if (typeof lang === 'string' && typeof data === 'object') {
            var obj = {};
            obj[lang] = data;
        } else
            obj = lang;
        this.text = this.extend(true, this.text, obj);
        return this;
    },
    _k:function(key) {
        var key2 = key,     /* step */
            s;     /* parenthesis */
        var step = key2.match(/^\d+\.[\s]+/);
        /* match 1. XXX */
        if (step) {
            key = key.replace(step, '');
        }
        /* match XXX(1-10) */
        while (s = key.match(/\([^()]*\)/)) {
            key = key.replace(s, '');
        }
        /* remove &nbsp; */
        key = key.replace(/&nbsp;/g, '');
        /* remove <br> */
        key = key.replace(/<br>/g, '');
        key = key.replace(/<\/br>/g, '');
        key = key.replace(/<hr>/g, '');
        key = key.replace(/<B>/g, '');
        key = key.replace(/<\/B>/g, '');
        /* trim */
        key = key.replace(/^[\s\xA0]+|[\s\xA0]+$/g, '');
        return key;
    },
    _getObj:function(key, json) {
        var keys = key.split('.'),
            obj = json;
        key = this._k(key);
        for (var i = 0; i < keys.length; i++) {
            if (keys[i].match(/^[a-zA-Z_][a-zA-Z0-9_]*$/) == null) {          /* match vaild json key */
                keys = [key];
                break;
            }
        }
        while (typeof obj !== 'undefined' && keys.length > 0)
            obj = obj[keys.shift()];

        return obj;
    },
    _get:function (key, json, lang) {
        var key2 = key,
            obj = this._getObj(key, json);

        if (typeof lang === 'undefined') {
            lang = this.getLang();
        }

        if (typeof json !== 'undefined' && key.length > 0 && typeof json[key] !== 'undefined') {
            return json[key];
        }
        key = this._k(key);
        if (typeof obj === 'undefined') {
            obj = key2;
        } else {
            obj = key2.replace(key, obj);
            obj = obj.replace(/\(/g, this.text[lang]['('] ? this.text[lang]['('] : '(');
            obj = obj.replace(/\)/g, this.text[lang][')'] ? this.text[lang][')'] : ')');
            obj = obj.replace(/:/g, this.text[lang][':'] ? this.text[lang][':'] : ':');
            obj = obj.replace(/,/g, this.text[lang][','] ? this.text[lang][','] : ',');
        }
        return obj;
    },
    get:function (key, lang) {
        var obj,
            res;
        var iFrameObj = parent.window.document.getElementById('mainIframe');
        var urlArr = iFrameObj ? iFrameObj.src.split('/') : document.location.href.split('/');
        var page = urlArr[urlArr.length - 1].split('?')[0];

        if (typeof lang === 'undefined') {
            lang = this.getLang();
        }

        obj = this.text[lang];

        if (typeof obj !== 'undefined' && page.length > 0 && typeof obj[page] !== 'undefined') {
            res = this._get(key, obj[page], lang);
            if (typeof res === 'string' && this._getObj(key, obj[page])) {
                return res;
            }
        }

        return this._get(key, obj, lang);
    },
    set:function (key) {
        var str = '<label i18n="' + key + '">' + this.get(key) + '<\/label>';
        return str;
    },
    no:function (key) {
        var str = '<label>' + key + '<\/label>';
        return str;
    },
    set_attr:function (key) {
        var str = '<label class="I18N">' + key + '<\/label>';
        return str;
    },
    t1:function (item, doc) {
        if (typeof item === 'object') {
            var it = item;
            /* not deep copy */
            key = it.getAttribute('i18n');
            this.removeClass(it, 'I18N');
            if (typeof key === 'undefined' || key == null) {
                if (it.innerHTML && it.innerHTML != '') {
                    key = it.innerHTML;
                } else if (it.value && it.value != '' && it.type && it.type == 'button') {
                    key = it.value;
                }
            }
            it.setAttribute('i18n', key);
            if (it.innerHTML && it.innerHTML != '') {
                it.innerHTML = this.get(key);
            } else if (it.value && it.value != '' && it.type && it.type == 'button') {
                it.value = this.get(key);
            }
        }
        return this;
    },
    t:function (doc, cb) {
        var d = doc ? doc : document;
        if (typeof this.text[this.getLang()] === 'undefined') {
            this.load(doc, cb);
            return this;
        }
        var l = new Array();
        var item = this.getElementByAttr(doc, 'I18N');
        for (var i = 0; i < item.length; i++) {
            l.push(item[i]);
        }
        if (doc.getElementsByClassName) {
            item = doc.getElementsByClassName('I18N');
            for (var i = 0; i < item.length; i++) {
                l.push(item[i]);
            }
        }
        for (var i in l)
            this.t1(l[i], doc);
        var subWindow = doc.getElementsByTagName('iframe');
        for (var i = 0; i < subWindow.length; i++) {
            this.t(subWindow[i].contentWindow.document);
        }
        if (cb) {
            cb(doc);
        }
        return this;
    }
};

